#include "videoinputdlg.h"
#include "ui_videoinputdlg.h"
#include "mainwindow.h"

VideoInputDlg::VideoInputDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::VideoInputDlg)
{
    ui->setupUi(this);

    this->setWindowTitle("VIDEO INPUT");

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    switch ( SC540dlg->m_nVideoInput ) {
        case 0:
            ui->radioCOMPOSITE->setChecked(true);
            break;
        case 1:
            ui->radioSVIDEO->setChecked(true);
            break;
        case 2:
            ui->radioHDMI->setChecked(true);
            break;
        case 3:
            ui->radioDVID->setChecked(true);
            break;
        case 4:
            ui->radioCOMPONENTS->setChecked(true);
            break;
        case 5:
            ui->radioDVIA->setChecked(true);
            break;
        case 6:
            ui->radioSDI->setChecked(true);
            break;
        default:
            break;
    }
}

VideoInputDlg::~VideoInputDlg()
{
    delete ui;
}

void VideoInputDlg::on_pushButton_ok_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    if( ui->radioHDMI->isChecked() )
    {
        QCAP_SET_VIDEO_INPUT( SC540dlg->m_hVideoDevice, QCAP_INPUT_TYPE_HDMI);
    }
    if( ui->radioDVID->isChecked() )
    {
        QCAP_SET_VIDEO_INPUT( SC540dlg->m_hVideoDevice, QCAP_INPUT_TYPE_DVI_D);
    }
    if( ui->radioCOMPONENTS->isChecked() )
    {
        QCAP_SET_VIDEO_INPUT( SC540dlg->m_hVideoDevice, QCAP_INPUT_TYPE_COMPONENTS);
    }
    if( ui->radioDVIA->isChecked() )
    {
        QCAP_SET_VIDEO_INPUT( SC540dlg->m_hVideoDevice, QCAP_INPUT_TYPE_DVI_A);
    }
    if( ui->radioSDI->isChecked() )
    {
        QCAP_SET_VIDEO_INPUT( SC540dlg->m_hVideoDevice, QCAP_INPUT_TYPE_SDI);
    }
    if( ui->radioCOMPOSITE->isChecked() )
    {
        QCAP_SET_VIDEO_INPUT( SC540dlg->m_hVideoDevice, QCAP_INPUT_TYPE_COMPOSITE);
    }
    if( ui->radioSVIDEO->isChecked() )
    {
        QCAP_SET_VIDEO_INPUT( SC540dlg->m_hVideoDevice, QCAP_INPUT_TYPE_SVIDEO);
    }

    this->close();
}
